# Installation

We recommend user to create a virtual environment for running this project. We list details of the environment setup process as follows:

## Create and activate new conda env.

```
conda create -n my-conda-env python=3.7
conda activate my-conda-env
```

## Note: pytorch is needed, so you need to install it based on your own system conditions. Here we use Linux and CUDA version 11.7 as an example.

```pip3 install torch torchvision torchaudio```

## Next, install other dependencies listed in requirement.txt

```pip install -r requirements.txt```



# Reproduce experiment results

All scripts for each method are in script/ folder where subfolder contains policies for 1D, 2D, and 3D tasks. You can find all hyperparameters used for each case in the config/ folder which has the same structure as script/ folder. The scripts for simulation environments are in Env/ folder. You can easily reproduce the experiments by running the algorithm scripts with its corresponding hyperparameters in the YML files. For example, if I want to train the DQN policy on 2D variable dense task:

```
cd script/DQN/2d/
python DQN_2d_dynamic.py ../../../config/DQN/2D/dynamic_dense.yml
```


# Multiprocess

We also provide a multiprocess script for batch simulation. 

python multiprocess.py --env 1DStatic --plan_type 0 --num_envs 5








